package ndbclient

import "context"

var (
	dataDeletePath = "/jsgo.xbind.ndb.api.data/Delete"
)

type DataDelete struct {
	groupId  string
	formIdId map[string][]string
	arg      map[string]interface{}
}

func Delete(groupId string) *DataDelete {
	return &DataDelete{
		groupId: groupId,
	}
}

func (d *DataDelete) SetGroupId(groupId string) *DataDelete {
	d.groupId = groupId
	return d
}

func (d *DataDelete) SetDataIds(formId string, dataIds []string) *DataDelete {
	if _, ok := d.formIdId[formId]; ok {
		d.formIdId[formId] = nil
	}
	for _, v := range dataIds {
		d.AddDataId(formId, v)
	}
	return d
}

func (d *DataDelete) AddDataId(formId string, dataId string) *DataDelete {
	if d.formIdId == nil {
		d.formIdId = make(map[string][]string)
	}
	d.formIdId[formId] = append(d.formIdId[formId], dataId)
	return d
}

func (d *DataDelete) Do(ctx context.Context) Response {
	return request(ctx, dataDeletePath, map[string]interface{}{
		"group_id":   d.groupId,
		"form_id/id": d.formIdId,
	})
}
