package ndbclient

type SqlBuilder interface {
	Select(fields ...string) SqlBuilder
	From(formId string) SqlBuilder
	Where(sql interface{}, args ...interface{}) SqlBuilder
	GetWhere() []Where
	WhereOr(sql interface{}, args ...interface{}) SqlBuilder
	//Limit(param ...int) SqlBuilder
	GroupBy(groupBy string) SqlBuilder
	OrderBy(orderBy string) SqlBuilder
	Build() (string, []interface{})
}

type Where struct {
	WhereType string
	Sql       string
	Args      []interface{}
	Child     []Where
}

func GetDefaultSqlBuilder() SqlBuilder {
	return NewDuckDBSqlBuilder()
}
