package ndbclient

import "context"

var (
	dataDetailPath = "/jsgo.xbind.ndb.api.data/Detail"
)

type DataDetail struct {
	groupId  string
	formIdId map[string][]string
	arg      map[string]interface{}
}

func Detail(groupId string) *DataDetail {
	return &DataDetail{
		groupId: groupId,
	}
}

func (d *DataDetail) SetGroupId(groupId string) *DataDetail {
	d.groupId = groupId
	return d
}

func (d *DataDetail) SetDataIds(formId string, dataIds []string) *DataDetail {
	if _, ok := d.formIdId[formId]; ok {
		d.formIdId[formId] = nil
	}
	for _, v := range dataIds {
		d.AddDataId(formId, v)
	}
	return d
}

func (d *DataDetail) AddDataId(formId string, dataId string) *DataDetail {
	if d.formIdId == nil {
		d.formIdId = make(map[string][]string)
	}
	d.formIdId[formId] = append(d.formIdId[formId], dataId)
	return d
}

func (d *DataDetail) Do(ctx context.Context) Response {
	return request(ctx, dataDetailPath, map[string]interface{}{
		"group_id":   d.groupId,
		"form_id/id": d.formIdId,
	})
}
