package ndbclient

import "context"

var (
	dataInsertPath = "/jsgo.xbind.ndb.api.data/Insert"
)

type DataInsert struct {
	groupId string
	rows    map[string][]interface{}
	arg     map[string]interface{}
}

func Insert(groupId string) *DataInsert {
	return &DataInsert{
		groupId: groupId,
	}
}

func (i *DataInsert) SetGroupId(groupId string) *DataInsert {
	i.groupId = groupId
	return i
}

func (i *DataInsert) SetFormRows(formId string, rows []interface{}) *DataInsert {
	if _, ok := i.rows[formId]; ok {
		i.rows[formId] = nil
	}
	for _, v := range rows {
		i.AddFormRow(formId, v)
	}
	return i
}

func (i *DataInsert) AddFormRow(formId string, row interface{}) *DataInsert {
	if i.rows == nil {
		i.rows = make(map[string][]interface{})
	}
	i.rows[formId] = append(i.rows[formId], row)
	return i
}

func (i *DataInsert) Do(ctx context.Context) Response {
	return request(ctx, dataInsertPath, map[string]interface{}{
		"group_id": i.groupId,
		"rows":     i.rows,
	})
}
