package ndbclient

import (
	"context"
	"testing"
)

func TestInsert(t *testing.T) {
	groupId := "test"
	res := Insert(groupId).SetFormRows("test", []interface{}{
		map[string]interface{}{
			"name": "john",
		},
		map[string]interface{}{
			"name": "lucy",
		},
	}).SetFormRows("test1", []interface{}{
		map[string]interface{}{
			"age":  18,
			"name": "john",
		},
		map[string]interface{}{
			"name": "lucy",
			"age":  28,
		},
	}).Do(context.Background())
	if !res.IsSuccess() {
		t.Errorf("insert err:%s", res.GetErrMsg())
		return
	}
}
