package ndbclient

import (
	"testing"
)

func TestBuild(t *testing.T) {
	builder := GetDefaultSqlBuilder()
	sql, args := builder.Select("name", "age").
		From("test").
		Where("name in (?, ?)", "john", "lucy").
		WhereOr(GetDefaultSqlBuilder().Where("create_at > ?", "2020-01-01").WhereOr("update_at > ?", "2020-01-01")).
		WhereOr("age = ?", 10).
		GroupBy("id desc").
		OrderBy("id desc").
		Build()
	t.Log(sql, args)
}
