package ndbclient

import (
	"context"
	"testing"
)

func TestSqlModelQuery(t *testing.T) {
	groupId := "test"
	formId := "test"
	sqlBuilder := NewDuckDBSqlBuilder().Select("*").From(formId).Where("name = ?", "john2")
	res := SqlModel(groupId, formId).SqlBuilder(sqlBuilder).Ctx(context.Background()).Find()
	if !res.IsSuccess() {
		t.Errorf("find err:%s", res.GetErrMsg())
		return
	}
	t.Log(res.GetResult())
}

func TestSqlModelUpdate(t *testing.T) {
	groupId := "test"
	formId := "test"
	sqlBuilder := NewDuckDBSqlBuilder().Select("id").From(formId).Where("name = ?", "john2")
	res := SqlModel(groupId, formId).SqlBuilder(sqlBuilder).Ctx(context.Background()).Update(map[string]interface{}{
		"name": "john3",
	})
	if !res.IsSuccess() {
		t.Errorf("update err:%s", res.GetErrMsg())
		return
	}
	t.Log(res.GetResult())
}

func TestSqlModelDelete(t *testing.T) {
	groupId := "test"
	formId := "test"
	sqlBuilder := NewDuckDBSqlBuilder().Select("id").From(formId).Where("name = ?", "john")
	res := SqlModel(groupId, formId).SqlBuilder(sqlBuilder).Ctx(context.Background()).Delete()
	if !res.IsSuccess() {
		t.Errorf("update err:%s", res.GetErrMsg())
		return
	}
	t.Log(res.GetResult())
}

//func TestSqlUpdate(t *testing.T) {
//	groupId := "test"
//	sql := "select * from test where name = ?"
//	res := Sql(groupId).SetSql(sql, "john").SetUpdate(map[string]interface{}{
//		"form_id": "test",
//		"set": map[string]interface{}{
//			"name": "john2",
//		},
//	}).Do(context.Background())
//	if !res.IsSuccess() {
//		t.Errorf("sql err:%s", res.GetErrMsg())
//		return
//	}
//	t.Log(res.GetResult())
//}
//
//func TestSqlDel(t *testing.T) {
//	groupId := "test"
//	sql := "select * from test where name = ? and id = ?"
//	res := Sql(groupId).SetSql(sql, "john2", "d5pdghk3shdonjtgk4dg").SetDel(map[string]interface{}{
//		"form_id": "test",
//		"softdel": 1,
//	}).Do(context.Background())
//	if !res.IsSuccess() {
//		t.Errorf("sql err:%s", res.GetErrMsg())
//		return
//	}
//	t.Log(res.GetResult())
//}
