package ndbclient

import (
	"context"
)

var (
	dataSqlPath = "/jsgo.xbind.ndb.api.data/Sql"
)

type DataSql struct {
	groupId string
	sql     string
	args    []interface{}
	limit   int
	detail  map[string]interface{}
	update  map[string]interface{}
	del     map[string]interface{}
}

func Sql(groupId string) *DataSql {
	return &DataSql{
		groupId: groupId,
	}
}

func (s *DataSql) SetGroupId(groupId string) *DataSql {
	s.groupId = groupId
	return s
}

func (s *DataSql) SetSql(sql string, args ...interface{}) *DataSql {
	s.sql = sql
	s.args = args
	return s
}

func (s *DataSql) SetLimit(limit int) *DataSql {
	s.limit = limit
	return s
}

func (s *DataSql) SetDetail(detail map[string]interface{}) *DataSql {
	s.detail = detail
	return s
}

func (s *DataSql) SetUpdate(update map[string]interface{}) *DataSql {
	s.update = update
	return s
}

func (s *DataSql) SetDel(del map[string]interface{}) *DataSql {
	s.del = del
	return s
}

func (s *DataSql) Do(ctx context.Context) Response {
	arg := map[string]interface{}{
		"group_id": s.groupId,
		"sql":      s.sql,
	}
	if s.args != nil {
		arg["args"] = s.args
	}
	if s.limit != 0 {
		arg["limit"] = s.limit
	}
	if s.detail != nil {
		arg["detail"] = s.detail
	}
	if s.update != nil {
		arg["update"] = s.update
	}
	if s.del != nil {
		arg["del"] = s.del
	}
	//fmt.Println(gojson.New(arg).ToJsonString())
	return request(ctx, dataSqlPath, arg)
}
