package ndbclient

import (
	"context"
	"net/http"
	"net/url"
	"path"

	"github.com/gogf/gf/v2/frame/g"
	"github.com/tidwall/gjson"
)

var (
	client  = g.Client()
	gOption Option
)

type Option struct {
	User string
	Pwd  string
	Addr string
	// MaxIdleConnsPerHost 设置每个host最大空闲连接数，通常5个，需要根据业务情况调整
	MaxIdleConnsPerHost int
}

func Init(option Option) {
	gOption = option
	// 设置连接池
	if gOption.MaxIdleConnsPerHost == 0 {
		gOption.MaxIdleConnsPerHost = 5
	}
	client.Transport.(*http.Transport).MaxIdleConnsPerHost = gOption.MaxIdleConnsPerHost
}

func request(ctx context.Context, urlPath string, arg map[string]interface{}) Response {
	body := map[string]interface{}{
		"arg": arg,
		"auth": map[string]interface{}{
			"user": gOption.User,
			"pwd":  gOption.Pwd,
		},
	}
	addr := gOption.Addr
	u, _ := url.Parse(addr)
	finalUrl := path.Join(u.Path, urlPath)
	r, err := client.ContentJson().Post(ctx, finalUrl, body)
	if err != nil {
		panic(err)
	}
	defer r.Close()
	return newResponse(r.ReadAllString())
}

type Response struct {
	result gjson.Result
	errMsg string
}

func newResponse(result string) Response {
	return Response{
		result: gjson.Parse(result),
	}
}

func (r *Response) IsSuccess() bool {
	if r.result.Get("code").Exists() && r.result.Get("code").Int() == 0 {
		return true
	}
	return false
}

func (r *Response) GetErrMsg() string {
	if !r.IsSuccess() {
		return r.result.Get("msg").String()
	}
	return ""
}
