package ndbclient

import "context"

var (
	dataInsertPath = "/jsgo.xbind.ndb.api.data/Insert"
)

type DataInsert struct {
	groupId string
	rows    map[string][]interface{}
	arg     map[string]interface{}
}

func Insert(groupId string) *DataInsert {
	return &DataInsert{
		groupId: groupId,
	}
}

func (i *DataInsert) SetGroupId(groupId string) *DataInsert {
	i.groupId = groupId
	return i
}

func (i *DataInsert) SetRows(tableName string, rows []interface{}) *DataInsert {
	i.rows = nil
	for _, v := range rows {
		i.AddRow(tableName, v)
	}
	return i
}

func (i *DataInsert) AddRow(tableName string, row interface{}) *DataInsert {
	if i.rows == nil {
		i.rows = make(map[string][]interface{})
	}
	i.rows[tableName] = append(i.rows[tableName], row)
	return i
}

func (i *DataInsert) Do(ctx context.Context) Response {
	return request(ctx, dataInsertPath, map[string]interface{}{
		"groupId": i.groupId,
		"rows":    i.rows,
	})
}
