package ndbclient

import (
	"os"
	"testing"
)

func TestMain(m *testing.M) {
	// 在所有测试之前进行全局设置
	setup()

	// 运行所有测试
	exitCode := m.Run()

	// 退出程序
	os.Exit(exitCode)
}

func setup() {
	option := Option{
		User:                os.Getenv("NDB_USER"),
		Pwd:                 os.Getenv("NDB_PWD"),
		Addr:                os.Getenv("NDB_ADDR"),
		MaxIdleConnsPerHost: 5,
	}
	Init(option)
}
