package ndbclient

import (
	"context"
	"testing"
)

func TestSqlQuery(t *testing.T) {
	groupId := "test"
	sql := "select * from test where name = ?"
	res := Sql(groupId).SetSql(sql, "john").Do(context.Background())
	if !res.IsSuccess() {
		t.Errorf("sql err:%s", res.GetErrMsg())
		return
	}
	t.Log(res.GetResult())
}

func TestSqlUpdate(t *testing.T) {
	groupId := "test"
	sql := "select * from test where name = ?"
	res := Sql(groupId).SetSql(sql, "john").SetUpdate(map[string]interface{}{
		"form_id": "test",
		"set": map[string]interface{}{
			"name": "john2",
		},
	}).Do(context.Background())
	if !res.IsSuccess() {
		t.Errorf("sql err:%s", res.GetErrMsg())
		return
	}
	t.Log(res.GetResult())
}

func TestSqlDel(t *testing.T) {
	groupId := "test"
	sql := "select * from test where name = ? and id = ?"
	res := Sql(groupId).SetSql(sql, "john2", "d5pdghk3shdonjtgk4dg").SetDel(map[string]interface{}{
		"form_id": "test",
		"softdel": 1,
	}).Do(context.Background())
	if !res.IsSuccess() {
		t.Errorf("sql err:%s", res.GetErrMsg())
		return
	}
	t.Log(res.GetResult())
}
